package lambda;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
@FunctionalInterface
interface IOSupplier<T> {
    T get() throws IOException;

    static <T> T unchecked(final IOSupplier<T> supplier) {
        try {
            return supplier.get();
        } catch (final IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void main(final String... args) {
        for (final String arg : args) {
            readAllLines(arg);
            lines(arg);
        }
    }

    private static void lines(final String arg) {
        try (final Stream<String> lines = IOSupplier.unchecked(() -> Files.lines(Path.of(arg)))) {
            System.out.println("--- Contents of " + arg);
            lines.forEach(System.out::println);
        }
    }

    private static void readAllLines(final String arg) {
        final List<String> lines = IOSupplier.unchecked(() -> Files.readAllLines(Path.of(arg)));
        System.out.println("--- Contents of " + arg);
        lines.forEach(System.out::println);
    }
}
