package lambda;

import java.util.Date;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
interface Log {
    default void info(final String message) {
        timed("INFO: " + message);
    }

    default void warning(final String message) {
        timed("WARN: " + message);
    }

    /*private*/ // For Java 9
    default     // For Java 8
    void timed(final String message) {
        log(new Date() + " " + message);
    }

    void log(String message);

    static void main(final String... args) {
        final Log log = System.out::println;
        for (final String arg : args) {
            if (arg.length() % 2 == 0) {
                log.info(arg);
            } else {
                log.warning(arg);
            }
        }
    }
}
