package net;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
public class HelloHttpServer {
    private static final int DEFAULT_PORT = 12345;

    public static void main(final String... args) throws IOException {
        final int port = getPort(args);
        final HttpServer server = HttpServer.create(
                new InetSocketAddress(port), // порт
                0 // размер очереди
        );
        server.setExecutor(null); // по-умолчанию

        final HttpHandler helloHandler = t -> {
            System.out.println("URI: " + t.getRequestURI());
            System.out.println("Method: " + t.getRequestMethod());

            final String name;
            try (InputStream is = t.getRequestBody()) {
                name = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).readLine();
            }
            final byte[] response = ("Hello, " + name + "\nQuery: " + t.getRequestURI().getQuery()).getBytes();
            t.sendResponseHeaders(HttpURLConnection.HTTP_OK, response.length);
            try (OutputStream os = t.getResponseBody()) {
                os.write(response);
            }
        };

        final HttpHandler stopHandler = t -> {
            System.out.println("Stopping");
            System.exit(0);
        };

        server.createContext("/", helloHandler);
        server.createContext("/stop", stopHandler);
        server.start();
    }

    public static int getPort(final String[] args) {
        return args.length > 0 ? Integer.parseInt(args[0]) : DEFAULT_PORT;
    }
}
