package nio;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.stream.IntStream;

public final class VirtualThreads {
    private VirtualThreads() {}

    private static final int N = 1000_000;

    public static void main(final String[] args) throws InterruptedException {
        for (int n = 100; n <= N; n *= 10) {
            run("Virtual", n, Thread.ofVirtual());
            run("Platform", n, Thread.ofPlatform());
        }
    }

    private static void run(final String type, final int n, final Thread.Builder builder) throws InterruptedException {
        System.out.println("=== " + type + " " + n);
        final long start = System.currentTimeMillis();

        final CountDownLatch started = new CountDownLatch(n);
        final CountDownLatch finished = new CountDownLatch(n);
        IntStream.range(0, n).forEach(i -> builder.start(() -> {
            started.countDown();
            try {
                Thread.sleep(Duration.ofSeconds(1));
            } catch (final InterruptedException ignore) {
            } finally {
                finished.countDown();
            }
        }));

        report("Create", start);
        started.await();
        report("Started", start);
        finished.await();
        report("Finished", start);
    }

    private static void report(final String stage, final long start) {
        System.out.printf("\t%-8s: %d ms%n", stage, System.currentTimeMillis() - start);
    }
}
