package reflection;

import java.lang.reflect.*;

/**
 * Example for {@link Proxy} class.
 */
public final class ProxyExample {
    public static void main(final String... args) {
        final Integer i1 = 3;
        final Profiler profiler = new Profiler(new Class<?>[]{Comparable.class}, i1);

        @SuppressWarnings("unchecked")
        final Comparable<Integer> i2 = (Comparable<Integer>) profiler.getInstance();

        System.out.println(i2.compareTo(i1));
    }
}
