import java.util.Arrays;
import java.util.Objects;

// Model: a[1]..a[n]
// Inv: n >= 0 && forall i=1..n: a[i] != null
// Let: immutable(k): forall i=1..k: a'[i] = a[i]
public class ArrayStack {
    private int size;
    private Object[] elements = new Object[5];

    // Pre: element != null
    // Post: n' = n + 1 &&
    //       a'[n'] = element &&
    //       immutable(n)
    // Полная форма
    public void push(ArrayStack this, Object element) {
        Objects.requireNonNull(element);

        this.ensureCapacity(size + 1);
        this.elements[this.size++] = element;
    }

    // Pre: true
    // Post: n' = n && immutable(n)
    // Неявный this
    private void ensureCapacity(int capacity) {
        if (capacity > this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, 2 * capacity);
        }
    }

    // Pre: n > 0
    // Post: R = a[n] && n' = n - 1 && immutable(n')
    // Необязательный this
    public Object pop() {
        assert size > 0;

        Object value = peek();
        elements[--size] = 0;
        return value;
    }

    // Pre: n > 0
    // Post: R = a[n] && n' = n && immutable(n)
    public Object peek() {
        assert size > 0;

        return elements[size - 1];
    }

    // Pre: true
    // Post: R = n && n' = n && immutable(n)
    public int size() {
        return size;
    }

    // Pre: true
    // Post: R = (n = 0) && n' = n && immutable(n)
    public boolean isEmpty() {
        return size == 0;
    }
}
