/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.LockManager;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NodeExecutionAdvisor;
import org.junit.platform.engine.support.hierarchical.NodeUtils;
import org.junit.platform.engine.support.hierarchical.ResourceLock;

class NodeTreeWalker {
    private final LockManager lockManager;
    private final ResourceLock globalReadLock;
    private final ResourceLock globalReadWriteLock;

    NodeTreeWalker() {
        this(new LockManager());
    }

    NodeTreeWalker(LockManager lockManager) {
        this.lockManager = lockManager;
        this.globalReadLock = lockManager.getLockForResource(ExclusiveResource.GLOBAL_READ);
        this.globalReadWriteLock = lockManager.getLockForResource(ExclusiveResource.GLOBAL_READ_WRITE);
    }

    NodeExecutionAdvisor walk(TestDescriptor rootDescriptor) {
        Preconditions.condition(this.getExclusiveResources(rootDescriptor).isEmpty(), "Engine descriptor must not declare exclusive resources");
        NodeExecutionAdvisor advisor = new NodeExecutionAdvisor();
        rootDescriptor.getChildren().forEach(child -> this.walk((TestDescriptor)child, (TestDescriptor)child, advisor));
        return advisor;
    }

    private void walk(TestDescriptor globalLockDescriptor, TestDescriptor testDescriptor, NodeExecutionAdvisor advisor) {
        Set<ExclusiveResource> exclusiveResources = this.getExclusiveResources(testDescriptor);
        if (exclusiveResources.isEmpty()) {
            advisor.useResourceLock(testDescriptor, this.globalReadLock);
            testDescriptor.getChildren().forEach(child -> this.walk(globalLockDescriptor, (TestDescriptor)child, advisor));
        } else {
            HashSet<ExclusiveResource> allResources = new HashSet<ExclusiveResource>(exclusiveResources);
            advisor.forceDescendantExecutionMode(testDescriptor, Node.ExecutionMode.SAME_THREAD);
            this.doForChildrenRecursively(testDescriptor, child -> {
                allResources.addAll(this.getExclusiveResources((TestDescriptor)child));
                advisor.forceDescendantExecutionMode((TestDescriptor)child, Node.ExecutionMode.SAME_THREAD);
            });
            if (!globalLockDescriptor.equals(testDescriptor) && allResources.contains(ExclusiveResource.GLOBAL_READ_WRITE)) {
                advisor.forceDescendantExecutionMode(globalLockDescriptor, Node.ExecutionMode.SAME_THREAD);
                this.doForChildrenRecursively(globalLockDescriptor, child -> advisor.forceDescendantExecutionMode((TestDescriptor)child, Node.ExecutionMode.SAME_THREAD));
                advisor.useResourceLock(globalLockDescriptor, this.globalReadWriteLock);
            }
            advisor.useResourceLock(testDescriptor, this.lockManager.getLockForResources(allResources));
        }
    }

    private Set<ExclusiveResource> getExclusiveResources(TestDescriptor testDescriptor) {
        return NodeUtils.asNode(testDescriptor).getExclusiveResources();
    }

    private void doForChildrenRecursively(TestDescriptor parent, Consumer<TestDescriptor> consumer) {
        parent.getChildren().forEach(child -> {
            consumer.accept((TestDescriptor)child);
            this.doForChildrenRecursively((TestDescriptor)child, consumer);
        });
    }
}

