/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.EventDispatchThread;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.peer.DialogPeer;

public class Dialog
extends Window {
    boolean resizable = true;
    boolean modal;
    String title;
    private static final String base = "dialog";
    private static int nameCounter;
    private static final long serialVersionUID = 5920926903803293709L;

    public Dialog(Frame frame) {
        this(frame, "", false);
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, "", bl);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        super(frame);
        if (frame == null) {
            throw new IllegalArgumentException("null parent frame");
        }
        this.title = string;
        this.modal = bl;
    }

    String constructComponentName() {
        return base + nameCounter++;
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createDialog(this);
            }
            super.addNotify();
            return;
        }
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String string) {
        this.title = string;
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer != null) {
            dialogPeer.setTitle(string);
        }
    }

    public void show() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.addNotify();
            }
        }
        this.validate();
        if (this.visible) {
            this.toFront();
            return;
        }
        this.visible = true;
        if (this.isModal()) {
            object = null;
            if (Thread.currentThread() instanceof EventDispatchThread) {
                object = new EventDispatchThread("AWT-Dispatch-Proxy", Toolkit.getEventQueue());
                ((Thread)object).start();
            }
            if ((this.state & 1) == 0) {
                this.postWindowEvent(200);
                this.state |= 1;
            }
            this.peer.show();
            if (object != null) {
                ((EventDispatchThread)object).stopDispatching();
                return;
            }
        } else {
            this.peer.show();
            if ((this.state & 1) == 0) {
                this.postWindowEvent(200);
                this.state |= 1;
            }
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public synchronized void setResizable(boolean bl) {
        this.resizable = bl;
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer != null) {
            dialogPeer.setResizable(bl);
        }
    }

    protected String paramString() {
        String string = String.valueOf(super.paramString()) + (this.modal ? ",modal" : ",modeless");
        if (this.title != null) {
            string = String.valueOf(string) + ",title=" + this.title;
        }
        return string;
    }
}

