/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SeedGenerator;
import java.util.Random;

public class SecureRandom
extends Random {
    private static SecureRandom seeder;
    private static final int DIGEST_SIZE = 20;
    private transient MessageDigest digest;
    private byte[] state;
    private byte[] remainder;
    private int remCount;

    public SecureRandom() {
        this(SecureRandom.nextSeed());
    }

    private static synchronized byte[] nextSeed() {
        if (seeder == null) {
            seeder = new SecureRandom(SecureRandom.getSeed(20));
            seeder.setSeed(SeedGenerator.getSystemEntropy());
        }
        byte[] byArray = new byte[20];
        seeder.nextBytes(byArray);
        return byArray;
    }

    public SecureRandom(byte[] byArray) {
        super(0L);
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        this.setSeed(byArray);
    }

    public synchronized void setSeed(byte[] byArray) {
        if (this.state != null) {
            this.digest.update(this.state);
            int n = 0;
            while (n < this.state.length) {
                this.state[n] = 0;
                ++n;
            }
        }
        this.state = this.digest.digest(byArray);
    }

    public void setSeed(long l) {
        if (l != 0L) {
            this.setSeed(SecureRandom.longToByteArray(l));
        }
    }

    private static void updateState(byte[] byArray, byte[] byArray2) {
        int n = 1;
        int n2 = 0;
        byte by = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < byArray.length) {
            n2 = byArray[n3] + byArray2[n3] + n;
            by = (byte)n2;
            bl |= byArray[n3] != by;
            byArray[n3] = by;
            n = n2 >> 8;
            ++n3;
        }
        if (!bl) {
            byArray[0] = (byte)(byArray[0] + 1);
        }
    }

    public synchronized void nextBytes(byte[] byArray) {
        int n;
        int n2;
        int n3 = 0;
        byte[] byArray2 = this.remainder;
        int n4 = this.remCount;
        if (n4 > 0) {
            n2 = byArray.length - n3 < 20 - n4 ? byArray.length - n3 : 20 - n4;
            n = 0;
            while (n < n2) {
                byArray[n] = byArray2[n4];
                byArray2[n4++] = 0;
                ++n;
            }
            this.remCount += n2;
            n3 += n2;
        }
        while (n3 < byArray.length) {
            this.digest.update(this.state);
            byArray2 = this.digest.digest();
            SecureRandom.updateState(this.state, byArray2);
            n2 = byArray.length - n3 > 20 ? 20 : byArray.length - n3;
            n = 0;
            while (n < n2) {
                byArray[n3++] = byArray2[n];
                byArray2[n] = 0;
                ++n;
            }
            this.remCount += n2;
        }
        this.remainder = byArray2;
        this.remCount %= 20;
    }

    protected final int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.nextBytes(byArray);
        int n4 = 0;
        while (n4 < n2) {
            n3 = (n3 << 8) + (byArray[n4] & 0xFF);
            ++n4;
        }
        return n3 >>> n2 * 8 - n;
    }

    public static byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = SeedGenerator.getByte();
            ++n2;
        }
        return byArray;
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)l;
            l >>= 8;
            ++n;
        }
        return byArray;
    }
}

